<?php
require_once __DIR__ . '/../includes/_init.php';
require_auth();

require_once __DIR__ . '/../../app/helpers.php';

$pdo = db();
$tripId = (int)($_GET['id'] ?? 0);

$st = $pdo->prepare("SELECT * FROM trips WHERE id=? AND user_id=?");
$st->execute([$tripId, (int)$_SESSION['user_id']]);
$trip = $st->fetch();
if (!$trip) { set_flash('danger','Trip not found.'); redirect('/user/dashboard.php'); }

$places = $pdo->prepare("SELECT tp.place_id, pm.name, pm.address, pm.lat, pm.lng, pm.rating, pm.photo_url, c.name AS category
                         FROM trip_places tp
                         JOIN places_master pm ON pm.id=tp.place_id
                         JOIN categories c ON c.id=tp.category_id
                         WHERE tp.trip_id=? AND tp.selected_flag=1");
$places->execute([$tripId]);
$places = $places->fetchAll();

$routeRow = $pdo->prepare("SELECT * FROM trip_route WHERE trip_id=?");
$routeRow->execute([$tripId]);
$route = $routeRow->fetch();

$schedRow = $pdo->prepare("SELECT * FROM trip_schedule WHERE trip_id=?");
$schedRow->execute([$tripId]);
$sched = $schedRow->fetch();

$routeOrder = $route ? json_decode($route['route_order_json'], true) : [];
$geojson = $route ? json_decode($route['geojson'], true) : null;
$schedule = $sched ? json_decode($sched['schedule_json'], true) : [];

$placeById = [];
foreach ($places as $p) $placeById[(int)$p['place_id']] = $p;

$pageTitle = "Trip: " . $trip['trip_name'];
include __DIR__ . '/../includes/header.php';
include __DIR__ . '/../includes/navbar_user.php';
?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<div class="container py-4">
  <?php if ($flash): ?>
    <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
  <?php endif; ?>

  <div class="d-flex flex-wrap justify-content-between align-items-start gap-2 mb-3">
    <div>
      <div class="text-muted small">City</div>
      <h2 class="fw-bold mb-1"><?= e($trip['trip_name']) ?></h2>
      <div class="text-muted"><?= e($trip['city_display'] ?? $trip['city']) ?> • <?= e(substr($trip['start_time'],0,5)) ?>–<?= e(substr($trip['end_time'],0,5)) ?></div>
    </div>
    <div class="d-flex gap-2">
      <form method="post" action="<?= BASE_URL ?>/user/regenerate_route.php" class="d-inline">
        <input type="hidden" name="<?= CSRF_KEY ?>" value="<?= csrf_token() ?>">
        <input type="hidden" name="trip_id" value="<?= $tripId ?>">
        <button class="btn btn-outline-light"><i class="fa-solid fa-rotate me-2"></i>Regenerate Route</button>
      </form>
      <a class="btn btn-primary" href="<?= BASE_URL ?>/user/dashboard.php"><i class="fa-solid fa-arrow-left me-2"></i>Back</a>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-lg-7">
      <div class="form-card p-3">
        <div class="d-flex justify-content-between align-items-center px-2 pt-2">
          <div class="fw-semibold">Route Map</div>
          <div class="text-muted small">
            Total distance: <?= $route ? number_format(($route['total_distance_m']/1000), 1) : '—' ?> km •
            Travel time: <?= $route ? gmdate('H:i', (int)$route['total_time_s']) : '—' ?>
          </div>
        </div>
        <div id="map" class="map-box mt-2" style="height:460px;"></div>
      </div>
    </div>

    <div class="col-lg-5">
      <div class="form-card p-4">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <div class="h5 fw-semibold mb-0">Places</div>
          <span class="text-muted small"><?= count($routeOrder) ?> stops</span>
        </div>

        <?php if (empty($routeOrder)): ?>
          <div class="text-muted">Route not generated yet.</div>
        <?php else: ?>
          <div class="vstack gap-2">
            <?php $i=1; foreach ($routeOrder as $pid): $p = $placeById[(int)$pid] ?? null; if(!$p) continue; ?>
              <div class="feature-card p-3">
                <div class="d-flex justify-content-between gap-2">
                  <div>
                    <div class="fw-semibold"><?= $i ?>. <?= e($p['name']) ?></div>
                    <div class="text-muted small"><?= e($p['category']) ?><?= $p['rating'] ? ' • Rating: '.e((string)$p['rating']) : '' ?></div>
                    <div class="text-muted small"><?= e($p['address'] ?? '') ?></div>
                  </div>
                  <div class="text-end">
                    <a class="btn btn-outline-light btn-sm mb-2" target="_blank"
                       href="https://www.google.com/maps?q=<?= e($p['lat']) ?>,<?= e($p['lng']) ?>">Open</a>
                    <form method="post" action="<?= BASE_URL ?>/user/remove_place.php">
                      <input type="hidden" name="<?= CSRF_KEY ?>" value="<?= csrf_token() ?>">
                      <input type="hidden" name="trip_id" value="<?= $tripId ?>">
                      <input type="hidden" name="place_id" value="<?= (int)$pid ?>">
                      <button class="btn btn-outline-danger btn-sm">Remove</button>
                    </form>
                  </div>
                </div>
              </div>
            <?php $i++; endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <div class="col-12">
      <div class="form-card p-4">
        <div class="h5 fw-semibold mb-2">Itinerary</div>
        <?php if (empty($schedule)): ?>
          <div class="text-muted">Schedule not generated yet.</div>
        <?php else: ?>
          <div class="table-responsive">
            <table class="table table-striped align-middle">
              <thead>
                <tr>
                  <th>Time</th>
                  <th>Activity</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($schedule as $s): ?>
                  <?php if ($s['type'] === 'travel'): ?>
                    <tr>
                      <td class="text-muted"><?= e($s['start']) ?>–<?= e($s['end']) ?></td>
                      <td class="fw-semibold">Travel</td>
                      <td class="text-muted small">To next place (<?= e((string)$s['minutes']) ?> min)</td>
                    </tr>
                  <?php elseif ($s['type'] === 'visit'): 
                    $p = $placeById[(int)$s['place_id']] ?? null;
                  ?>
                    <tr>
                      <td class="text-muted"><?= e($s['start']) ?>–<?= e($s['end']) ?></td>
                      <td class="fw-semibold">Visit</td>
                      <td><?= $p ? e($p['name']) : 'Place' ?> <span class="text-muted small">(<?= e((string)$s['minutes']) ?> min)</span></td>
                    </tr>
                  <?php else: ?>
                    <tr>
                      <td class="text-muted"><?= e($s['start']) ?>–<?= e($s['end']) ?></td>
                      <td class="fw-semibold">Buffer</td>
                      <td class="text-muted"><?= e($s['label'] ?? 'Free time') ?></td>
                    </tr>
                  <?php endif; ?>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>
    </div>

  </div>
</div>

<script>
  const cityLat = <?= json_encode((float)$trip['city_lat']) ?>;
  const cityLng = <?= json_encode((float)$trip['city_lng']) ?>;
  const startLat = <?= json_encode((float)$trip['start_lat']) ?>;
  const startLng = <?= json_encode((float)$trip['start_lng']) ?>;

  const map = L.map('map').setView([cityLat, cityLng], 12);
  L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    maxZoom: 19,
    attribution: '&copy; OpenStreetMap contributors'
  }).addTo(map);

  const startIcon = L.divIcon({
    className: 'custom-div-icon',
    html: '<div class="marker-badge marker-start">S</div>',
    iconSize: [30, 30],
    iconAnchor: [15, 15],
  });

  const stopIcon = (n) => L.divIcon({
    className: 'custom-div-icon',
    html: '<div class="marker-badge marker-stop">'+n+'</div>',
    iconSize: [30, 30],
    iconAnchor: [15, 15],
  });

  L.marker([startLat, startLng], {icon: startIcon}).addTo(map)
    .bindPopup("Start: <?= e($trip['start_label'] ?? 'Start') ?>");

  const routeOrder = <?= json_encode($routeOrder) ?>;
  const places = <?= json_encode($places) ?>;

  const placeById = {};
  places.forEach(p => placeById[p.place_id] = p);

  let n = 1;
  routeOrder.forEach(pid => {
    const p = placeById[pid];
    if (!p) return;
    L.marker([p.lat, p.lng], {icon: stopIcon(n)}).addTo(map)
      .bindPopup('<div style="min-width:200px"><div class="fw-semibold">'+escapeHtml(p.name)+'</div><div class="text-muted small">'+escapeHtml(p.category)+'</div></div>');
    n++;
  });

  const geojson = <?= json_encode($geojson) ?>;
  if (geojson && geojson.features && geojson.features[0]) {
    const layer = L.geoJSON(geojson, {style: {weight: 5, opacity: 0.8}});
    layer.addTo(map);
    try { map.fitBounds(layer.getBounds().pad(0.2)); } catch(e) {}
  }

  function escapeHtml(str){
    return String(str).replace(/[&<>"']/g, s => ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[s]));
  }
</script>

<style>
.marker-badge{
  width:30px;height:30px;border-radius:12px;
  display:grid;place-items:center;font-weight:800;
  border:1px solid rgba(148,163,184,.25);
  box-shadow: 0 10px 18px rgba(0,0,0,.25);
}
.marker-start{ background: rgba(34,197,94,.9); color:#052e16; }
.marker-stop{ background: rgba(79,70,229,.9); color:#0b1220; }
</style>

<?php include __DIR__ . '/../includes/footer.php'; ?>
