<?php
require_once __DIR__ . '/../includes/_init.php';
require_auth();
post_only();
csrf_verify();

require_once __DIR__ . '/../../app/services/RouteService.php';
require_once __DIR__ . '/../../app/services/TripEngine.php';

$pdo = db();
$tripId = (int)($_POST['trip_id'] ?? 0);

try {
  $st = $pdo->prepare("SELECT * FROM trips WHERE id=? AND user_id=?");
  $st->execute([$tripId, (int)$_SESSION['user_id']]);
  $trip = $st->fetch();
  if (!$trip) throw new Exception('Trip not found.');

  $visitMinutes = (int)$trip['visit_minutes'];
  $startTime = substr($trip['start_time'],0,5);
  $endTime = substr($trip['end_time'],0,5);
  $availSeconds = strtotime($endTime) - strtotime($startTime);

  $stPl = $pdo->prepare("SELECT tp.place_id, pm.name, pm.lat, pm.lng, tp.score
                         FROM trip_places tp
                         JOIN places_master pm ON pm.id=tp.place_id
                         WHERE tp.trip_id=? AND tp.selected_flag=1
                         ORDER BY tp.score DESC");
  $stPl->execute([$tripId]);
  $places = $stPl->fetchAll();
  if (count($places) < 1) throw new Exception('No places selected.');

  $dropped = 0;
  while (count($places) > 0) {
    $idxToPlaceId = [0 => 'START'];
    $coords = [[(float)$trip['start_lng'], (float)$trip['start_lat']]];
    $i = 1;
    foreach ($places as $pl) {
      $idxToPlaceId[$i] = (int)$pl['place_id'];
      $coords[] = [(float)$pl['lng'], (float)$pl['lat']];
      $i++;
    }

    $mx = RouteService::matrix($coords);
    $dur = $mx['durations'] ?? null;
    $dist = $mx['distances'] ?? null;
    if (!$dur || !$dist) throw new Exception('Matrix API returned incomplete data.');

    $orderIdx = TripEngine::nearestNeighborOrder($dur);
    $routePlaceIds = [];
    for ($k=1; $k<count($orderIdx); $k++) $routePlaceIds[] = $idxToPlaceId[$orderIdx[$k]];

    $totalTravel = 0; $totalDistance = 0;
    for ($k=0; $k<count($orderIdx)-1; $k++) {
      $a=$orderIdx[$k]; $b=$orderIdx[$k+1];
      $totalTravel += (float)($dur[$a][$b] ?? 0);
      $totalDistance += (float)($dist[$a][$b] ?? 0);
    }
    $totalVisit = count($routePlaceIds) * ($visitMinutes*60);
    $total = $totalTravel + $totalVisit;

    if ($total <= $availSeconds) {
      $orderedCoords = [[(float)$trip['start_lng'], (float)$trip['start_lat']]];
      foreach ($orderIdx as $idx) if ($idx != 0) $orderedCoords[] = $coords[$idx];
      $geojson = RouteService::directions($orderedCoords);

      $pdo->beginTransaction();
      $pdo->prepare("DELETE FROM trip_route WHERE trip_id=?")->execute([$tripId]);
      $pdo->prepare("DELETE FROM trip_schedule WHERE trip_id=?")->execute([$tripId]);

      $pdo->prepare("INSERT INTO trip_route (trip_id,route_order_json,total_distance_m,total_time_s,geojson,created_at) VALUES (?,?,?,?,?,?)")
          ->execute([$tripId, json_encode($routePlaceIds), $totalDistance, $totalTravel, json_encode($geojson), now()]);

      $schedule = TripEngine::buildSchedule($startTime, $endTime, $routePlaceIds, $visitMinutes, $dur, $idxToPlaceId);
      $pdo->prepare("INSERT INTO trip_schedule (trip_id,schedule_json,created_at) VALUES (?,?,?)")
          ->execute([$tripId, json_encode($schedule), now()]);
      $pdo->commit();

      set_flash('success', 'Route regenerated' . ($dropped ? ' (reduced places to fit time).' : '.'));
      redirect('/user/trip_view.php?id=' . $tripId);
    }

    array_pop($places);
    $dropped++;
  }

  throw new Exception('Time window too small. Increase end time or reduce visit duration.');

} catch (Exception $ex) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  set_flash('danger', $ex->getMessage());
  redirect('/user/trip_view.php?id=' . $tripId);
}
