<?php
require_once __DIR__ . '/../includes/_init.php';
require_auth();

$pdo = db();
$userId = (int)$_SESSION['user_id'];

$st = $pdo->prepare("SELECT id,name,email,phone FROM users WHERE id=?");
$st->execute([$userId]);
$u = $st->fetch();
if (!$u) { set_flash('danger','User not found.'); redirect('/auth/logout.php'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $action = $_POST['action'] ?? '';

  if ($action === 'profile') {
    $name = trim($_POST['name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    if ($name === '') {
      set_flash('danger','Name is required.');
      redirect('/user/profile.php');
    }
    $up = $pdo->prepare("UPDATE users SET name=?, phone=? WHERE id=?");
    $up->execute([$name, $phone ?: null, $userId]);
    $_SESSION['user_name'] = $name;
    set_flash('success','Profile updated.');
    redirect('/user/profile.php');
  }

  if ($action === 'password') {
    $old = (string)($_POST['old_password'] ?? '');
    $new = (string)($_POST['new_password'] ?? '');
    if (strlen($new) < 8) {
      set_flash('danger','New password must be at least 8 characters.');
      redirect('/user/profile.php');
    }
    $st2 = $pdo->prepare("SELECT password_hash FROM users WHERE id=?");
    $st2->execute([$userId]);
    $hash = $st2->fetch()['password_hash'] ?? '';
    if (!$hash || !password_verify($old, $hash)) {
      set_flash('danger','Old password is incorrect.');
      redirect('/user/profile.php');
    }
    $newHash = password_hash($new, PASSWORD_BCRYPT);
    $up = $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?");
    $up->execute([$newHash, $userId]);
    set_flash('success','Password changed.');
    redirect('/user/profile.php');
  }
}

$pageTitle = "Profile";
include __DIR__ . '/../includes/header.php';
include __DIR__ . '/../includes/navbar_user.php';
?>
<div class="container py-4">
  <?php if ($flash): ?>
    <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
  <?php endif; ?>

  <div class="row g-3">
    <div class="col-lg-6">
      <div class="form-card p-4">
        <div class="h5 fw-semibold mb-3">Profile</div>
        <form method="post" class="vstack gap-3">
          <input type="hidden" name="<?= CSRF_KEY ?>" value="<?= csrf_token() ?>">
          <input type="hidden" name="action" value="profile">
          <div>
            <label class="form-label">Name</label>
            <input class="form-control" name="name" value="<?= e($u['name']) ?>" required>
          </div>
          <div>
            <label class="form-label">Email</label>
            <input class="form-control" value="<?= e($u['email']) ?>" disabled>
          </div>
          <div>
            <label class="form-label">Phone</label>
            <input class="form-control" name="phone" value="<?= e($u['phone'] ?? '') ?>" placeholder="Optional">
          </div>
          <button class="btn btn-primary">Save Changes</button>
        </form>
      </div>
    </div>

    <div class="col-lg-6">
      <div class="form-card p-4">
        <div class="h5 fw-semibold mb-3">Change Password</div>
        <form method="post" class="vstack gap-3">
          <input type="hidden" name="<?= CSRF_KEY ?>" value="<?= csrf_token() ?>">
          <input type="hidden" name="action" value="password">
          <div>
            <label class="form-label">Old Password</label>
            <input type="password" class="form-control" name="old_password" required>
          </div>
          <div>
            <label class="form-label">New Password</label>
            <input type="password" class="form-control" name="new_password" required placeholder="Min 8 characters">
          </div>
          <button class="btn btn-outline-light">Update Password</button>
        </form>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
