<?php
require_once __DIR__ . '/../includes/_init.php';
require_auth();

$pdo = db();
$st = $pdo->prepare("SELECT * FROM trips WHERE user_id=? ORDER BY created_at DESC");
$st->execute([$_SESSION['user_id']]);
$trips = $st->fetchAll();

$pageTitle = "Dashboard";
include __DIR__ . '/../includes/header.php';
include __DIR__ . '/../includes/navbar_user.php';
?>
<div class="container py-4">
  <?php if ($flash): ?>
    <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
  <?php endif; ?>

  <div class="d-flex flex-wrap justify-content-between align-items-center gap-2 mb-3">
    <div>
      <h2 class="fw-bold mb-1">Hi, <?= e($_SESSION['user_name'] ?? 'Traveler') ?> 👋</h2>
      <div class="text-muted">Create a new trip plan or reopen any saved itinerary.</div>
    </div>
    <a class="btn btn-primary" href="<?= BASE_URL ?>/user/create_trip.php"><i class="fa-solid fa-plus me-2"></i>Create Trip</a>
  </div>

  <div id="mytrips" class="form-card p-3 p-md-4">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <div class="h5 fw-semibold mb-0">My Trips</div>
      <span class="text-muted small"><?= count($trips) ?> total</span>
    </div>

    <?php if (empty($trips)): ?>
      <div class="text-muted">No saved trips yet. Create your first trip now.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
          <thead>
            <tr>
              <th>Trip</th>
              <th>City</th>
              <th>Time</th>
              <th>Places</th>
              <th>Created</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($trips as $t): 
            $cnt = $pdo->prepare("SELECT COUNT(*) c FROM trip_places WHERE trip_id=? AND selected_flag=1");
            $cnt->execute([$t['id']]);
            $placesCount = (int)($cnt->fetch()['c'] ?? 0);
          ?>
            <tr>
              <td class="fw-semibold"><?= e($t['trip_name']) ?></td>
              <td><?= e($t['city']) ?></td>
              <td><?= e(substr($t['start_time'],0,5)) ?>–<?= e(substr($t['end_time'],0,5)) ?></td>
              <td><?= $placesCount ?></td>
              <td class="text-muted"><?= e(date('d M Y', strtotime($t['created_at']))) ?></td>
              <td class="text-end">
                <a class="btn btn-outline-light btn-sm" href="<?= BASE_URL ?>/user/trip_view.php?id=<?= (int)$t['id'] ?>">
                  Open
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
