<?php
require_once __DIR__ . '/../includes/_init.php';
require_once __DIR__ . '/../../app/helpers.php';
require_once __DIR__ . '/../../app/db.php';

$pageTitle = "Signup";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $name = trim($_POST['name'] ?? '');
  $email = strtolower(trim($_POST['email'] ?? ''));
  $password = (string)($_POST['password'] ?? '');
  $phone = trim($_POST['phone'] ?? '');

  if ($name === '' || $email === '' || $password === '') {
    set_flash('danger', 'Name, Email, and Password are required.');
    redirect('/auth/signup.php');
  }
  if (!validate_email($email)) {
    set_flash('danger', 'Invalid email format.');
    redirect('/auth/signup.php');
  }
  if (strlen($password) < 8) {
    set_flash('danger', 'Password must be at least 8 characters.');
    redirect('/auth/signup.php');
  }

  $pdo = db();
  $st = $pdo->prepare("SELECT id FROM users WHERE email=? LIMIT 1");
  $st->execute([$email]);
  if ($st->fetch()) {
    set_flash('danger', 'Email already registered. Please login.');
    redirect('/auth/login.php');
  }

  $hash = password_hash($password, PASSWORD_BCRYPT);
  $ins = $pdo->prepare("INSERT INTO users (name,email,password_hash,phone,created_at) VALUES (?,?,?,?,?)");
  $ins->execute([$name, $email, $hash, $phone ?: null, now()]);

  set_flash('success', 'Account created successfully. Please login.');
  redirect('/auth/login.php');
}

include __DIR__ . '/../includes/header.php';
include __DIR__ . '/../includes/navbar_public.php';
?>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-6">
      <div class="form-card p-4">
        <h3 class="fw-bold mb-1">Create your account</h3>
        <div class="text-muted mb-4">Start planning smarter trips in minutes.</div>

        <?php if ($flash): ?>
          <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
        <?php endif; ?>

        <form method="post" class="vstack gap-3">
          <input type="hidden" name="<?= CSRF_KEY ?>" value="<?= csrf_token() ?>">
          <div>
            <label class="form-label">Full name</label>
            <input class="form-control" name="name" required placeholder="Your name">
          </div>
          <div>
            <label class="form-label">Email</label>
            <input class="form-control" name="email" required placeholder="name@example.com">
          </div>
          <div>
            <label class="form-label">Password</label>
            <input type="password" class="form-control" name="password" required placeholder="Min 8 characters">
          </div>
          <div>
            <label class="form-label">Mobile (optional)</label>
            <input class="form-control" name="phone" placeholder="10-digit number">
          </div>
          <button class="btn btn-primary btn-lg">Create Account</button>
          <div class="text-muted small">
            Already have an account? <a href="<?= BASE_URL ?>/auth/login.php" class="text-decoration-underline">Login</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
