<?php
require_once __DIR__ . '/includes/admin_init.php';
require_admin();

$pdo = db();
$rows = $pdo->query("SELECT u.id,u.name,u.email,u.phone,u.created_at,
                    (SELECT COUNT(*) FROM trips t WHERE t.user_id=u.id) AS trips_count
                    FROM users u ORDER BY u.created_at DESC")->fetchAll();

$pageTitle = "Users";
$active = "users";
include __DIR__ . '/includes/admin_layout_top.php';
include __DIR__ . '/includes/admin_sidebar.php';
?>
<main class="admin-main">
  <?php if ($flash): ?>
    <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
  <?php endif; ?>

  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-3">
    <div>
      <div class="text-muted small">Directory</div>
      <h2 class="fw-bold mb-0">Users</h2>
    </div>
    <div class="text-muted small"><?= count($rows) ?> users</div>
  </div>

  <div class="card p-4">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead>
          <tr>
            <th>Name</th><th>Email</th><th>Phone</th><th>Trips</th><th>Joined</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $u): ?>
            <tr>
              <td class="fw-semibold"><?= e($u['name']) ?></td>
              <td><?= e($u['email']) ?></td>
              <td class="text-muted"><?= e($u['phone'] ?? '—') ?></td>
              <td><?= (int)$u['trips_count'] ?></td>
              <td class="text-muted"><?= e(date('d M Y', strtotime($u['created_at']))) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</main>
<?php include __DIR__ . '/includes/admin_layout_bottom.php'; ?>
