<?php
require_once __DIR__ . '/includes/admin_init.php';
require_admin();

$pdo = db();
$users = (int)($pdo->query("SELECT COUNT(*) c FROM users")->fetch()['c'] ?? 0);
$trips = (int)($pdo->query("SELECT COUNT(*) c FROM trips")->fetch()['c'] ?? 0);
$cats = (int)($pdo->query("SELECT COUNT(*) c FROM categories WHERE is_active=1")->fetch()['c'] ?? 0);

$latestTrips = $pdo->query("SELECT t.id, t.trip_name, t.city, t.created_at, u.name AS user_name
                            FROM trips t JOIN users u ON u.id=t.user_id
                            ORDER BY t.created_at DESC LIMIT 8")->fetchAll();

$pageTitle = "Dashboard";
$active = "dashboard";
include __DIR__ . '/includes/admin_layout_top.php';
include __DIR__ . '/includes/admin_sidebar.php';
?>
<main class="admin-main">
  <?php if ($flash): ?>
    <div class="alert alert-<?= e($flash['type']) ?>" data-autodismiss="1"><?= e($flash['msg']) ?></div>
  <?php endif; ?>

  <div class="d-flex justify-content-between align-items-start flex-wrap gap-2 mb-3">
    <div>
      <div class="text-muted small">Overview</div>
      <h2 class="fw-bold mb-0">Admin Dashboard</h2>
    </div>
    <div class="text-muted small">Logged in as <?= e($_SESSION['admin_name'] ?? 'Admin') ?></div>
  </div>

  <div class="row g-3">
    <div class="col-md-4">
      <div class="card p-4">
        <div class="d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Users</div>
            <div class="h2 fw-bold mb-0"><?= $users ?></div>
          </div>
          <i class="fa-solid fa-users fs-2 text-muted"></i>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card p-4">
        <div class="d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Trips</div>
            <div class="h2 fw-bold mb-0"><?= $trips ?></div>
          </div>
          <i class="fa-solid fa-route fs-2 text-muted"></i>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card p-4">
        <div class="d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Active Categories</div>
            <div class="h2 fw-bold mb-0"><?= $cats ?></div>
          </div>
          <i class="fa-solid fa-list-check fs-2 text-muted"></i>
        </div>
      </div>
    </div>
  </div>

  <div class="card p-4 mt-3">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <div class="h5 fw-semibold mb-0">Latest Trips</div>
      <a class="btn btn-outline-light btn-sm" href="<?= BASE_URL ?>/admin/trips.php">View all</a>
    </div>
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead>
          <tr>
            <th>Trip</th>
            <th>User</th>
            <th>City</th>
            <th>Created</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($latestTrips as $t): ?>
            <tr>
              <td class="fw-semibold"><?= e($t['trip_name']) ?></td>
              <td><?= e($t['user_name']) ?></td>
              <td><?= e($t['city']) ?></td>
              <td class="text-muted"><?= e(date('d M Y', strtotime($t['created_at']))) ?></td>
              <td class="text-end">
                <a class="btn btn-outline-light btn-sm" href="<?= BASE_URL ?>/admin/trip_view.php?id=<?= (int)$t['id'] ?>">Open</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</main>
<?php include __DIR__ . '/includes/admin_layout_bottom.php'; ?>
