CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(190) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  phone VARCHAR(30) NULL,
  created_at DATETIME NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS admins (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(190) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  created_at DATETIME NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS categories (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(80) NOT NULL UNIQUE,
  slug VARCHAR(80) NOT NULL UNIQUE,
  otm_kind VARCHAR(120) NOT NULL,
  icon VARCHAR(40) NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS trips (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  trip_name VARCHAR(120) NOT NULL,
  city VARCHAR(190) NOT NULL,
  city_display VARCHAR(255) NULL,
  city_lat DOUBLE NOT NULL,
  city_lng DOUBLE NOT NULL,
  start_label VARCHAR(255) NULL,
  start_lat DOUBLE NOT NULL,
  start_lng DOUBLE NOT NULL,
  start_time TIME NOT NULL,
  end_time TIME NOT NULL,
  pace ENUM('relaxed','normal','fast') NOT NULL DEFAULT 'normal',
  budget ENUM('low','medium','high') NULL,
  max_places INT NOT NULL DEFAULT 8,
  avoid_long_travel TINYINT(1) NOT NULL DEFAULT 0,
  visit_minutes INT NOT NULL DEFAULT 60,
  created_at DATETIME NOT NULL,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS trip_preferences (
  id INT AUTO_INCREMENT PRIMARY KEY,
  trip_id INT NOT NULL,
  category_id INT NOT NULL,
  FOREIGN KEY (trip_id) REFERENCES trips(id) ON DELETE CASCADE,
  FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS places_master (
  id INT AUTO_INCREMENT PRIMARY KEY,
  external_place_id VARCHAR(120) NOT NULL UNIQUE,
  name VARCHAR(255) NOT NULL,
  address VARCHAR(255) NULL,
  lat DOUBLE NOT NULL,
  lng DOUBLE NOT NULL,
  rating DOUBLE NULL,
  photo_url TEXT NULL,
  created_at DATETIME NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS trip_places (
  id INT AUTO_INCREMENT PRIMARY KEY,
  trip_id INT NOT NULL,
  place_id INT NOT NULL,
  category_id INT NOT NULL,
  score DOUBLE NOT NULL,
  selected_flag TINYINT(1) NOT NULL DEFAULT 1,
  FOREIGN KEY (trip_id) REFERENCES trips(id) ON DELETE CASCADE,
  FOREIGN KEY (place_id) REFERENCES places_master(id) ON DELETE CASCADE,
  FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS trip_route (
  id INT AUTO_INCREMENT PRIMARY KEY,
  trip_id INT NOT NULL UNIQUE,
  route_order_json JSON NOT NULL,
  total_distance_m DOUBLE NOT NULL,
  total_time_s DOUBLE NOT NULL,
  geojson JSON NULL,
  created_at DATETIME NOT NULL,
  FOREIGN KEY (trip_id) REFERENCES trips(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS trip_schedule (
  id INT AUTO_INCREMENT PRIMARY KEY,
  trip_id INT NOT NULL UNIQUE,
  schedule_json JSON NOT NULL,
  created_at DATETIME NOT NULL,
  FOREIGN KEY (trip_id) REFERENCES trips(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
