<?php
require_once __DIR__ . '/../helpers.php';

class GeoService {
    public static function geocodeCity(string $city): array {
        $q = urlencode(trim($city));
        $url = "https://nominatim.openstreetmap.org/search?format=json&limit=1&q={$q}";
        $data = http_json($url);
        if (empty($data)) {
            throw new Exception("City not found. Please enter a valid city.");
        }
        return [
            'display_name' => $data[0]['display_name'] ?? $city,
            'lat' => (float)$data[0]['lat'],
            'lng' => (float)$data[0]['lon'],
        ];
    }

    public static function geocodeLocation(string $query): array {
        $q = urlencode(trim($query));
        $url = "https://nominatim.openstreetmap.org/search?format=json&limit=1&q={$q}";
        $data = http_json($url);
        if (empty($data)) {
            throw new Exception("Location not found. Please enter a valid starting location.");
        }
        return [
            'display_name' => $data[0]['display_name'] ?? $query,
            'lat' => (float)$data[0]['lat'],
            'lng' => (float)$data[0]['lon'],
        ];
    }
}
